#include <iostream>
#include <vector>
#include <set>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    vector<int> P(N);
    for (int i = 0; i < N; ++i) {
        cin >> P[i];
    }

    // ???? ???????? ??? P[i] > P[i+1]
    set<int> breaks;
    for (int i = 0; i < N - 1; ++i) {
        if (P[i] > P[i + 1]) {
            breaks.insert(i);
        }
    }

    auto update = [&](int i) {
        if (i < 0 || i >= N - 1) return;
        if (P[i] > P[i + 1]) {
            breaks.insert(i);
        } else {
            breaks.erase(i);
        }
    };

    // ?????????? ??????? ???? ???????
    cout << breaks.size() << '\n';

    while (Q--) {
        int i, j;
        cin >> i >> j;
        --i; --j; // ???????? ?? 0-???????? ???????????

        if (i == j) {
            cout << breaks.size() << '\n';
            continue;
        }

        // ???? ???????? ???? ???? ???? ???????? ???????
        set<int> affected = {i - 1, i, j - 1, j};

        // ????????? ??? ??????
        for (int pos : affected) {
            update(pos);
        }

        // ?????????? ??????
        swap(P[i], P[j]);

        // ????????? ????? ??????
        for (int pos : affected) {
            update(pos);
        }

        // ?????????? ???????? ???? ???????
        cout << breaks.size() << '\n';
    }

    return 0;
}